{
  'targets': [
    {
      'target_name': 'binding',
      'win_delay_load_hook': 'true',
      'sources': [
        'src/binding.cpp',
        'src/create_string.cpp',
        'src/custom_function_bridge.cpp',
        'src/custom_importer_bridge.cpp',
        'src/sass_context_wrapper.cpp',
        'src/sass_types/boolean.cpp',
        'src/sass_types/color.cpp',
        'src/sass_types/error.cpp',
        'src/sass_types/factory.cpp',
        'src/sass_types/list.cpp',
        'src/sass_types/map.cpp',
        'src/sass_types/null.cpp',
        'src/sass_types/number.cpp',
        'src/sass_types/string.cpp'
      ],
      'include_dirs': [
        '<!(node -e "require(\'nan\')")',
      ],
      'conditions': [
        ['libsass_ext == "" or libsass_ext == "no"', {
          'dependencies': [
            'src/libsass.gyp:libsass',
          ]
        }],
        ['libsass_ext == "auto"', {
          'cflags_cc': [
            '<!(pkg-config --cflags libsass)',
          ],
          'link_settings': {
            'ldflags': [
              '<!(pkg-config --libs-only-other --libs-only-L libsass)',
            ],
            'libraries': [
              '<!(pkg-config --libs-only-l libsass)',
            ],
          }
        }],
        ['libsass_ext == "yes"', {
          'cflags_cc': [
            '<(libsass_cflags)',
          ],
          'link_settings': {
            'ldflags': [
              '<(libsass_ldflags)',
            ],
            'libraries': [
              '<(libsass_library)',
            ],
          }
        }],
        ['OS=="mac"', {
          'xcode_settings': {
            'OTHER_CPLUSPLUSFLAGS': [
              '-std=c++11',
              '-stdlib=libc++'
            ],
            'OTHER_LDFLAGS': [],
            'GCC_ENABLE_CPP_EXCEPTIONS': 'YES',
            'MACOSX_DEPLOYMENT_TARGET': '10.7'
          }
        }],
        ['OS=="win"', {
          'msvs_settings': {
            'VCCLCompilerTool': {
              'AdditionalOptions': [
                '/EHsc'
              ]
            }
          }
        }],
        ['OS!="win"', {
          'cflags_cc+': [
            '-fexceptions',
            '-std=c++0x'
          ]
        }]
      ]
    }
  ]
}
