#define SASS_FUNCTIONS

#include <cstring>
#include <map>

#ifndef SASS_NODE
#include "node.hpp"
#endif

namespace Sass {
  struct Environment;
  struct Context;

  using std::map;
  
  // typedef Node (*Primitive)(const Node, map<Token, Node>&, Node_Factory& new_Node);
  typedef Node (*Primitive)(const Node, Environment&, Node_Factory&);
  typedef const char* str;
  typedef const char Signature[];

  struct Function {
    
    string name;
    // vector<Token> parameters;
    Node parameters;
    Node parameter_names;
    Node definition;
    Primitive primitive;
    // Primitive_2 primitive_2;
    bool overloaded;
    
    Function()
    { /* TO DO: set up the generic callback here */ }

    // for user-defined functions
    Function(Node def)
    : name(def[0].to_string()),
      parameters(def[1]),
      definition(def),
      primitive(0),
      overloaded(false)
    { }

    // Stub for overloaded primitives
    Function(string name, bool overloaded = true)
    : name(name),
      parameters(Node()),
      definition(Node()),
      primitive(0),
      overloaded(overloaded)
    { }

    Function(char* signature, Primitive ip, Context& ctx);
    
    // Function(Function_Descriptor d, Primitive ip, Node_Factory& new_Node)
    // : name(d[0]),
    //   parameters(new_Node(Node::parameters, "[PRIMITIVE FUNCTIONS]", 0, 0)),
    //   definition(Node()),
    //   primitive(ip),
    //   overloaded(false)
    // {
    //   size_t len = 0;
    //   while (d[len+1]) ++len;
      
    //   for (size_t i = 0; i < len; ++i) {
    //     const char* p = d[i+1];
    //     parameters.push_back(new_Node(Node::variable, "[PRIMITIVE FUNCTIONS]", 0, Token::make(p, p + std::strlen(p))));
    //   }
    // }

    Node operator()(Environment& bindings, Node_Factory& new_Node) const
    {
      if (primitive) return primitive(parameters, bindings, new_Node);
      else           return Node();
    }

  };
  
  namespace Functions {

    extern const char foo_sig[];
    Node foo(const Node parameters, Environment& bindings, Node_Factory& new_Node);

    // RGB Functions ///////////////////////////////////////////////////////

    extern Signature rgb_sig;
    Node rgb(const Node, Environment&, Node_Factory&);

    extern Signature rgba_4_sig;
    Node rgba_4(const Node, Environment&, Node_Factory&);
    
    extern Signature rgba_2_sig;
    Node rgba_2(const Node, Environment&, Node_Factory&);
    
    extern Signature red_sig;
    Node red(const Node, Environment&, Node_Factory&);
    
    extern Signature green_sig;
    Node green(const Node, Environment&, Node_Factory&);
    
    extern Signature blue_sig;
    Node blue(const Node, Environment&, Node_Factory&);
    
    extern Signature mix_sig;
    Node mix(const Node, Environment&, Node_Factory&);
    
    // HSL Functions ///////////////////////////////////////////////////////
    
    extern Signature hsla_sig;
    Node hsla(const Node, Environment&, Node_Factory&);
    
    extern Signature hsl_sig;
    Node hsl(const Node, Environment&, Node_Factory&);

    extern Signature adjust_hue_sig;
    Node adjust_hue(const Node, Environment&, Node_Factory&);

    extern Signature invert_sig;
    Node invert(const Node, Environment&, Node_Factory&);
    
    // Opacity Functions ///////////////////////////////////////////////////

    extern Signature alpha_sig;
    extern Signature opacity_sig;
    Node alpha(const Node, Environment&, Node_Factory&);
    
    extern Signature opacify_sig;
    extern Signature fade_in_sig;
    Node opacify(const Node, Environment&, Node_Factory&);
    
    extern Signature transparentize_sig;
    extern Signature fade_out_sig;
    Node transparentize(const Node, Environment&, Node_Factory&);
    
    // String Functions ////////////////////////////////////////////////////

    extern Signature unquote_sig;
    Node unquote(const Node, Environment&, Node_Factory&);
    
    extern Signature quote_sig;
    Node quote(const Node, Environment&, Node_Factory&);
    
    // Number Functions ////////////////////////////////////////////////////

    extern Signature percentage_sig;
    Node percentage(const Node, Environment&, Node_Factory&);

    extern Signature round_sig;
    Node round(const Node, Environment&, Node_Factory&);

    extern Signature ceil_sig;
    Node ceil(const Node, Environment&, Node_Factory&);

    extern Signature floor_sig;
    Node floor(const Node, Environment&, Node_Factory&);

    extern Signature abs_sig;    
    Node abs(const Node, Environment&, Node_Factory&);
    
    // List Functions //////////////////////////////////////////////////////
    
    extern Signature length_sig;
    Node length(const Node, Environment&, Node_Factory&);

    extern Signature nth_sig;
    Node nth(const Node, Environment&, Node_Factory&);

    extern Signature join_sig;    
    Node join(const Node, Environment&, Node_Factory&);

    extern Signature append_sig;
    Node append(const Node, Environment&, Node_Factory&);

    extern Signature compact_sig;
    Node compact(const Node, Environment&, Node_Factory&);
    
    // Introspection Functions /////////////////////////////////////////////
    
    extern Signature type_of_sig;
    Node type_of(const Node, Environment&, Node_Factory&);

    extern Signature unit_sig;
    Node unit(const Node, Environment&, Node_Factory&);
    
    extern Signature unitless_sig;    
    Node unitless(const Node, Environment&, Node_Factory&);
    
    extern Signature comparable_sig;    
    Node comparable(const Node, Environment&, Node_Factory&);
    
    // Boolean Functions ///////////////////////////////////////////////////
    
    extern Signature not_sig;
    Node not_impl(const Node, Environment&, Node_Factory&);

    extern Signature if_sig;
    Node if_impl(const Node, Environment&, Node_Factory&);

  }
  
}
