const { hashMessage } = require('./helpers/sign');

const AutoIncrementing = artifacts.require('AutoIncrementingImpl');

require('chai')
  .use(require('chai-bignumber')(web3.BigNumber))
  .should();

const EXPECTED = [1, 2, 3, 4];
const KEY1 = hashMessage('key1');
const KEY2 = hashMessage('key2');

contract('AutoIncrementing', function ([_, owner]) {
  beforeEach(async function () {
    this.mock = await AutoIncrementing.new({ from: owner });
  });

  context('custom key', async function () {
    it('should return expected values', async function () {
      for (const expectedId of EXPECTED) {
        await this.mock.doThing(KEY1, { from: owner });
        const actualId = await this.mock.theId();
        actualId.should.be.bignumber.eq(expectedId);
      }
    });
  });

  context('parallel keys', async function () {
    it('should return expected values for each counter', async function () {
      for (const expectedId of EXPECTED) {
        await this.mock.doThing(KEY1, { from: owner });
        let actualId = await this.mock.theId();
        actualId.should.be.bignumber.eq(expectedId);

        await this.mock.doThing(KEY2, { from: owner });
        actualId = await this.mock.theId();
        actualId.should.be.bignumber.eq(expectedId);
      }
    });
  });
});
